<?php
// STATIC CLASS CONTAINING METHODS IMPLEMENTING AND EXECUTING USER MAIL VERIFICATION SYSTEM

class pcma_mail_verif {
    
    // users list e-mail flag
    public static function user_list_flag($badges, $user_id) {

        if(get_option('pcma_mv_enable') && pcma_is_active() && pcma_user_is_verified($user_id)) {
            $badges .= '<img src="'.PCMA_URL.'/img/mail_verified.png" title="'. esc_attr( __('e-mail verified', PCMA_ML)) .'" />';
        }

        return $badges;
    }
    



    // flag and manual validation for admin user dashboard
    public static function user_dashboard_mail_verif($sections, $user_id) {

        if(!get_option('pcma_mv_enable') || !pcma_is_active() || !$user_id) {
            return $sections;	
        }

        return 
        $sections + array(
            'pcma_mv' => array(
                'name'		=> 'Mail Actions add-on - '. __('E-mail Verification', PCMA_ML),
                'classes'	=> '',
                'callback' 	=> 'pcma_mail_verif::user_dashboard_mail_verif_cb',
            )
        );	
    }
    
    // flag and manual validation for admin user dashboard - callback
    public static function user_dashboard_mail_verif_cb($user_id) {
        
        // if is verified
        if(pcma_user_is_verified($user_id)) {
            echo '
            <div class="pc_warn pc_wps_warn pc_success">
                '.__("Account successfully verified via e-mail", PCMA_ML); 

                if(pc_wpuc_static::current_wp_user_can_edit_pc_user($user_id)) {
                    echo '
                    <button type="button" class="button-secondary" id="pcma_mv_del_validate">'. __("Dismiss Verification", PCMA_ML) .'</button>';
                }

            echo '	
            </div>';
        }

        // if not
        else {
            global $pc_users;
            $user_email = $pc_users->get_user_field($user_id, 'email');


            // if there is not mail
            if(empty($user_email)) {
                echo '
                <div class="pc_warn pc_wps_warn pc_error">
                    '.__("Verification Impossible - User has no e-mail", PCMA_ML).'
                </div>';
            }

            else {
                echo '
                <div class="pc_warn pc_wps_warn pc_warning">
                    '.__('Account not verified yet', PCMA_ML); 

                    if(pc_wpuc_static::current_wp_user_can_edit_pc_user($user_id)) {
                        echo '
                        <button type="button" class="button-secondary" id="pcma_mv_validate">'. __("Verify Manually", PCMA_ML) .'</button>
                        <button type="button" class="button-secondary" id="pcma_send_vmail">'. __("Send Validation E-mail", PCMA_ML) .'</button>';
                    }

                echo '	
                </div>';	
            }
        }


        // javascript to validate and un-validate - only if CUC
        if(pc_wpuc_static::current_wp_user_can_edit_pc_user($user_id)) :
        ?>
        <script type="text/javascript">
        (function($) { 
            "use strict"; 

            const nonce = '<?php echo wp_create_nonce('lcwp_nonce') ?>'; 
            let is_acting = false;

            // send validation mail
            $(document).on('click', '#pcma_send_vmail', function(e) {
                e.preventDefault();

                if(!confirm("<?php esc_attr_e('Send account validation e-mail to user?', PCMA_ML) ?>")) {
                    return true;    
                }

                const $btn = $(this);
                $btn.fadeTo(200, 0.7);
                is_acting = true;

                let data = {
                    action: 'pcma_manual_send_vmail',
                    pcma_uid: <?php echo $user_id; ?>,
                    nonce: nonce,
                };
                $.post(ajaxurl, data, function(response) {
                    if($.trim(response) == 'success') {
                        lc_wp_popup_message('success', "<?php esc_attr_e("Verification e-mail successfully sent", PCMA_ML) ?>");
                    }
                    else {
                        lc_wp_popup_message('error', response);
                    }

                })
                .fail(function(e) {
                    if(e.status) {    
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_attr_e("Error sending verification e-mail", PCMA_ML) ?>");
                    }
                })
                .always(function() {
                    $btn.fadeTo(200, 1);
                    is_acting = false;
                });
            });


            // validate manually
            $(document).on('click', '#pcma_mv_validate', function(e) {
                e.preventDefault();

                if(!confirm("<?php esc_attr_e('Confirm account validation?', PCMA_ML) ?>")) {
                    return true;    
                }

                const $btn = $(this);
                $btn.fadeTo(200, 0.7);
                is_acting = true;

                let data = {
                    action: 'pcma_mv_manual',
                    pcma_uid: <?php echo $user_id; ?>,
                    nonce: nonce,
                };
                $.post(ajaxurl, data, function(response) {

                    if($.trim(response) == 'success') {
                        $btn.parents('.pc_warn').removeClass('pc_warning').addClass('pc_success');

                        $btn.parents('.pc_warn').html(
                            "<?php esc_attr_e("Account successfully verified via e-mail", PCMA_ML) ?>" +
                            "<button class='button-secondary' id='pcma_mv_del_validate'>" +
                                "<?php esc_attr_e("Dismiss Verification", PCMA_ML) ?>" +
                            "</button>"
                        );
                    }
                    else {
                        lc_wp_popup_message('error', response);
                    }
                })
                .fail(function(e) {
                    if(e.status) {    
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_attr_e("Error verifying the user", PCMA_ML) ?>");
                    }
                })
                .always(function() {
                    $btn.fadeTo(200, 1);
                    is_acting = false;
                });
            });


            // cancel validation
            $(document).on('click', '#pcma_mv_del_validate', function(e) {
                e.preventDefault();

                if(!confirm("<?php esc_attr_e('Dismiss e-mail validation?', PCMA_ML) ?>")) {
                    return true;    
                }

                const $btn = $(this);
                $btn.fadeTo(200, 0.7);
                is_acting = true;

                let data = {
                    action: 'pcma_del_mv_manual',
                    pcma_uid: <?php echo $user_id; ?>,
                    nonce: nonce,
                };
                $.post(ajaxurl, data, function(response) {
                    if($.trim(response) == 'success') {
                        lc_wp_popup_message('success', "<?php esc_attr_e("Verification successfully dismissed!", PCMA_ML) ?>");

                        setTimeout(function() {
                            window.location.reload();
                        }, 1800);
                    }
                    else {
                        lc_wp_popup_message('error', response);

                        $btn.fadeTo(200, 1);
                        is_acting = false;
                    }
                })
                .fail(function(e) {
                    if(e.status) {
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_attr_e("Error dismissing the verification", PCMA_ML) ?>");

                        $btn.fadeTo(200, 1);
                        is_acting = false;
                    }
                });
            });
        })(jQuery);    
        </script>
        <?php
        endif;
    }



    // force e-mail use in registration forms if Users Verification or psw recovery with mail are active
    public static function set_mail_required($form_structure, $form_id) {
        if(pcma_is_active()) {
            if(get_option('pcma_mv_enable') || (get_option('pcma_psw_recovery') && get_option('pcma_pr_with_email')) ) {
                if(!in_array('email', $form_structure['include'])) {$form_structure['include'][] = 'email';}
                if(!in_array('email', $form_structure['require'])) {$form_structure['require'][] = 'email';}
            }
        }

        return $form_structure;
    }
    



    // send verification e-mail to user - after successfull registration
    public static function send_mail_verif($user_id, $user_page_id = false, $user_data = array()) {
        if(!pcma_is_active() || !get_option('pcma_mv_enable') || !get_option('pcma_mv_pag')) {
            return false;    
        } 
        global $pc_users;

        // get user data
        if(empty($user_data)) {
            $user_data = $pc_users->get_user($user_id, array('to_get' => array('name', 'surname', 'username', 'email', 'tel', 'psw', 'categories', 'status', 'page_id')));
        }

        // only if user is pending or if forcing sending
        if(!empty($user_data['email']) && (isset($GLOBALS['pcma_force_mail_verif_sending']) || $user_data['status'] == 3)) {

            // if page id is not specified
            if(!$user_page_id) {
                $user_page_id = $user_data['page_id'];
            }

            // create an unique id and store it for the user
            $valid_id = uniqid();
            $structure = array('id' => $valid_id, 'validated' => 0);
            update_post_meta($user_page_id, 'pcma_verif_id', $structure);
            
            // validation url
            $redir = pc_static::wpml_translated_pag_id(get_option('pcma_mv_pag'));
            $baselink = get_permalink($redir);
            $sign = (strpos($baselink, '?') === false) ? '?' : '&';

            $full_link = $baselink . $sign . 'pcma_user='.$user_id.'&pcma_key='.$valid_id;

            $ph = '%VER-URL%';
            $mail_txt = get_option('pcma_mv_txt');

            // detect whether placeholder is inside an HTML attribute
            $ph_pos = strpos($mail_txt, $ph);

            if(!$ph_pos || 
                (substr($mail_txt, ($ph_pos - 2), 2) != '="' || substr($mail_txt, ($ph_pos + strlen($ph)), 1) != '"') &&
                (substr($mail_txt, ($ph_pos - 2), 2) != "='" || substr($mail_txt, ($ph_pos + strlen($ph)), 1) != "'")
            ) {
                $full_link = '<a href="'. $full_link .'">'. $full_link .'</a>';
            }

            $mail_title = pcma_replace_placeholders($user_id, get_option('pcma_mv_subj'));

            $mail_txt = pcma_apply_mail_templates(get_option('pcma_mv_template'), $mail_txt);
            $mail_txt = str_replace($ph, $full_link, $mail_txt);
            $mail_txt = pcma_replace_placeholders($user_id, $mail_txt, $user_data);

            // send mail
            return pcma_send_mail($user_data['username'], $user_data['email'], $mail_title, $mail_txt);
        }
    }
    
    
    
    
    // MANAGE E-MAIL VERIFICATION PAGE
    public static function mv_page_check() {
        global $wpdb, $post, $current_user, $pc_users;

        $target_pag = pc_static::wpml_translated_pag_id(get_option('pcma_mv_pag'));

        if(!is_page() || $post->ID != $target_pag || !pcma_is_active() || !get_option('pcma_mv_enable')) {
            return false;    
        }
        
        
        $table_name = $wpdb->prefix . "pc_users";
        $is_admin = current_user_can('manage_options');

        // get parameters
        $user_id 	= (isset($_REQUEST['pcma_user'])) ? (int)$_REQUEST['pcma_user'] : 0; 
        $key 		= (isset($_REQUEST['pcma_key'])) ? $_REQUEST['pcma_key'] : 0; 
        $admin_mode = (isset($_REQUEST['pcma-test'])) ? $_REQUEST['pcma-test'] : false;

        // allow page preview by admins
        $is_admin_user = current_user_can('edit_pages');
        
        // check user id existence	
        $pag_id = $pc_users->get_user_field($user_id, 'page_id');

        // if parameters are missing and is not an admin test redirect to homepage
        if( 
            !$is_admin_user &&
            (empty($pag_id) || !isset($_REQUEST['pcma_key'])) && 
            (!$is_admin || !isset($_REQUEST['pcma-test']))
        ) {
            wp_safe_redirect(get_home_url());	
        }

        // check validation key (1=>ok, 2=>already validated, 0=>wrong)
        if(!$is_admin_user && !empty($pag_id)) {
            $user_key = get_post_meta($pag_id, 'pcma_verif_id', true);

            if(is_array($user_key) && isset($user_key['id']) && $user_key['id'] == $key) {
                $valid_key = (!$user_key['validated']) ? 1 : 2;
            }
            else {
                $valid_key = 0;
            }
        }

        
        // admin is previewing
        if($is_admin_user) {
            $mess = 
                '<p><strong style="color: firebrick;">'. __("PREVIEW MODE: page contents will be dynamically replaced accordingly with Mail Action's user verification settings. This page is NOT directly reachable!", PCMA_ML) .'</strong></p>'.  
                '<br/><h3>'. __("Confirmation message", PCMA_ML) .'</h3><hr/>'. self::get_landing_pag_content(1).
                '<br/><p>&nbsp;</p><h3>'. __("Already active message", PCMA_ML) .'</h3><hr/>'. self::get_landing_pag_content(2).
                '<br/><p>&nbsp;</p><h3>'. __("Error message", PCMA_ML) .'</h3><hr/>'. self::get_landing_pag_content(0);   
        }

        // error message
        elseif(empty($pag_id) || !$valid_key || ($is_admin && $admin_mode == 'error')) {
            $mess = self::get_landing_pag_content(0);
        }

        // already verified message
        elseif($valid_key === 2 || ($is_admin && $admin_mode == 'validated')) {
            $mess = self::get_landing_pag_content(2);
        }

        // validated successfully
        elseif($valid_key === 1 || ($is_admin && $admin_mode == 'success')) {
            $mess = self::get_landing_pag_content(1);

            if($user_id && $key) {

                // enable user
                if(get_option('pcma_mv_behav') != 'ignore') {
                    $pc_users->change_status($user_id, 1);
                }

                // validate user e-mail
                update_post_meta($pag_id, 'pcma_is_verified', 1);

                // update user validation id
                $user_key = array(
                    'id' => $key, 
                    'validated' => 1
                );
                update_post_meta($pag_id, 'pcma_verif_id', $user_key, true);

                do_action('pcma_user_verified_email', $user_id);
            }
        }

        // store message and throw content changer
        $GLOBALS['pcma_mv_mess'] = $mess;
        
        if(get_option('pcma_mv_pag_behav', 'full_replace') != 'shortcode') {
            add_filter('the_content', 'pcma_mail_verif::mv_page_content', 999);
        }

        // hide page comments
        add_filter('comments_template', 'pc_comments_template', 999);
    }

    
    /* return landing page content for a specific operation status (sucsess, error, etc) */
    protected static function get_landing_pag_content($status) {
        
        switch($status) {
            case 0 :
                $mess = (string)get_option('pcma_mv_bad_mess');
                $fallback = __('Sorry, your request is invalid or your account has been deleted', PCMA_ML);    
                break;
                
            case 1 :
                $mess = (string)get_option('pcma_mv_ok_mess');
                $fallback = __('Your account has been successfully activated!', PCMA_ML);
                break;
                
            case 2 :
                $mess = (string)get_option('pcma_mv_act_mess');	
                $fallback = __('Your account has been already activated!', PCMA_ML);  
                break;
        }
        
        return (empty(strip_tags($mess))) ? $fallback : $mess;
    }
    
    
    
    
    // MANAGE E-MAIL VERIFICATION PAGE CONTENTS
    public static function mv_page_content($content) {
        $new_content = do_shortcode( $GLOBALS['pcma_mv_mess'] );
        return wpautop($new_content);
    }
    
    
    
    
    // remove target page from WP queries
    public static function remove_page_from_queries($query) {
        global $wp_query;

        if(get_option('pcma_mv_enable') && !is_admin()) {
            $to_remove = (int)get_option('pcma_mv_pag');

            if(
                (is_object($wp_query) && !$wp_query->is_page()) ||
                (is_object($wp_query) && is_object($wp_query->queried_object) && $wp_query->queried_object->ID != $to_remove)
            ) {

                if(isset($query->query_vars['post__not_in'])) { 
                    $to_remove = array_merge((array)$query->query_vars['post__not_in'], (array)$to_remove); 
                }

                $query->set('post__not_in', $to_remove);
            }
        }

        return $query;
    }
    
    
    

    // landing page texts through [pcma-mv-pag-txt] shortcode 
    public static function landing_page_txt_sc($atts, $content = null) {
        return (isset($GLOBALS['pcma_mv_mess'])) ? $GLOBALS['pcma_mv_mess'] : '';
    }
}



add_filter('pc_users_list_badges', 'pcma_mail_verif::user_list_flag', 10, 2); // users list e-mail flag
add_filter('pc_user_dashboard_main_tab_sections', 'pcma_mail_verif::user_dashboard_mail_verif', 20, 2); // flag and manual validation for admin user dashboard
add_filter('pc_registration_form', 'pcma_mail_verif::set_mail_required', 999, 2); // force e-mail use in registration forms if Users Verification or psw recovery with mail are active

add_action('pc_registered_user', 'pcma_mail_verif::send_mail_verif'); // send verification e-mail to user - after successfull registration
add_action('pc_user_created_from_wp_register', 'pcma_mail_verif::send_mail_verif'); // do the same also for users auto-synced from WP

add_action('template_redirect', 'pcma_mail_verif::mv_page_check'); // MANAGE E-MAIL VERIFICATION PAGE
add_filter('pre_get_posts', 'pcma_mail_verif::remove_page_from_queries'); // remove target page from WP queries

add_shortcode('pcma-mv-pag-txt', 'pcma_mail_verif::landing_page_txt_sc');
